/* ///////////////////////////////////////////////////////////////////////// */
/*  This is part of the source of the OMAP 5912 heterogeneous dual-core      */
/*  MPEG-4 SP video decoder published in ACM Transactions on Embedded        */
/*  Computing Systems, Vol. X, Issue Y.                                      */
/* ------------------------------------------------------------------------- */
/*  The source code is released under GPL license.                           */
/*                                                                           */
/*  Copyright, 2011                                                          */
/*  Multimedia Embedded Systems Labs                                         */
/*  Dept. of Computer Science                                                */
/*  National Chiao Tung University                                           */
/*  Hsinchu, Taiwan.                                                         */
/* ///////////////////////////////////////////////////////////////////////// */

#define ARM_SPACE
///////////////Internal memory space
#ifdef DSP_SPACE
////////////////////External
#define Bistream_address 0x280000   //64kbyts frame size
#define cur_y_address 0x00380000+0x2000 //CIF is 352*288=0x18C00
#define cur_u_address 0x003A0000+0x1000 //CIF is 176*144=0x6300
#define cur_v_address 0x003A8000+0x1000

#define refn_y_address 0x003B0000+0x2000
#define refn_u_address 0x003D0000+0x1000
#define refn_v_address 0x003D8000+0x1000

#define FRAME_BUFFER_address 0x300010
#endif

////////////////////////////////////////////////////////////////////
#ifdef ARM_SPACE

#define Bistream_address (0x11200000)
#define cur_y_address ((0x00380000+0x2000)*2+0x11000000)    //0x11704000
#define cur_u_address ((0x003A0000+0x1000)*2+0x11000000)
#define cur_v_address ((0x003A8000+0x1000)*2+0x11000000)

#define refn_y_address ((0x003B0000+0x2000)*2+0x11000000)   //0x11764000
#define refn_u_address ((0x003D0000+0x1000)*2+0x11000000)
#define refn_v_address ((0x003D8000+0x1000)*2+0x11000000)

#define FRAME_BUFFER_address ((0x300010*2)+0x11000000)
#endif
